using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;

using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgCancelActiveOrderComment
	/// </summary>
	public class DlgCancelActiveOrderComment : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private System.Windows.Forms.Button btnCancel;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.GroupBox grpComment;
		private System.Windows.Forms.Label lblMessage;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbComment;
		private System.Windows.Forms.Label lblComment;
		private System.Windows.Forms.TextBox txtComment;
		private System.Windows.Forms.Label lblDetails;
		private System.Windows.Forms.GroupBox grpIcon;
		private System.Windows.Forms.PictureBox picWarning;
		private System.ComponentModel.IContainer components = null;
		private Guid _cannedCommentGuid;
		private string _cannedCommentText;
		private DataTable _dtCannedComments;

		/// <summary>
		/// Constructor
		/// </summary>
		public DlgCancelActiveOrderComment()
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();

			SetComponentProperties();
}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgCancelActiveOrderComment));
			this.btnCancel = new System.Windows.Forms.Button();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.grpComment = new System.Windows.Forms.GroupBox();
			this.lblMessage = new System.Windows.Forms.Label();
			this.cmbComment = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblComment = new System.Windows.Forms.Label();
			this.txtComment = new System.Windows.Forms.TextBox();
			this.lblDetails = new System.Windows.Forms.Label();
			this.grpIcon = new System.Windows.Forms.GroupBox();
			this.picWarning = new System.Windows.Forms.PictureBox();
			this.grpComment.SuspendLayout();
			this.grpIcon.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(352, 30);
			this.vbecsLogo1.TabIndex = 3;
			this.vbecsLogo1.Title = "Cancel Order(s)";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 204);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 5;
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(272, 188);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 2;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(192, 188);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 1;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// grpComment
			// 
			this.grpComment.AccessibleDescription = "Enter a comment to justify order cancellation.";
			this.grpComment.AccessibleName = "Enter a comment to justify order cancellation.";
			this.grpComment.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpComment.Controls.Add(this.lblMessage);
			this.grpComment.Controls.Add(this.cmbComment);
			this.grpComment.Controls.Add(this.lblComment);
			this.grpComment.Controls.Add(this.txtComment);
			this.grpComment.Controls.Add(this.lblDetails);
			this.grpComment.Location = new System.Drawing.Point(60, 32);
			this.grpComment.Name = "grpComment";
			this.grpComment.Size = new System.Drawing.Size(288, 152);
			this.grpComment.TabIndex = 0;
			this.grpComment.TabStop = false;
			// 
			// lblMessage
			// 
			this.lblMessage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblMessage.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblMessage.Location = new System.Drawing.Point(8, 12);
			this.lblMessage.Name = "lblMessage";
			this.lblMessage.Size = new System.Drawing.Size(272, 28);
			this.lblMessage.TabIndex = 0;
			this.lblMessage.Text = "Enter a comment to justify order cancellation.";
			this.lblMessage.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// cmbComment
			// 
			this.cmbComment.AccessibleDescription = "comment";
			this.cmbComment.AccessibleName = "comment";
			this.cmbComment.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbComment.Interval = 100;
			this.cmbComment.Location = new System.Drawing.Point(68, 48);
			this.cmbComment.Name = "cmbComment";
			this.cmbComment.Size = new System.Drawing.Size(204, 22);
			this.cmbComment.TabIndex = 2;
			this.cmbComment.SelectedIndexChanged += new System.EventHandler(this.cmbComment_SelectedIndexChanged);
			// 
			// lblComment
			// 
			this.lblComment.Location = new System.Drawing.Point(8, 48);
			this.lblComment.Name = "lblComment";
			this.lblComment.Size = new System.Drawing.Size(60, 20);
			this.lblComment.TabIndex = 1;
			this.lblComment.Text = "Comment*";
			this.lblComment.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtComment
			// 
			this.txtComment.AccessibleDescription = "details";
			this.txtComment.AccessibleName = "details";
			this.txtComment.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtComment.Location = new System.Drawing.Point(68, 72);
			this.txtComment.MaxLength = 255;
			this.txtComment.Multiline = true;
			this.txtComment.Name = "txtComment";
			this.txtComment.Size = new System.Drawing.Size(204, 68);
			this.txtComment.TabIndex = 4;
			this.txtComment.Text = "";
			// 
			// lblDetails
			// 
			this.lblDetails.Location = new System.Drawing.Point(8, 72);
			this.lblDetails.Name = "lblDetails";
			this.lblDetails.Size = new System.Drawing.Size(60, 20);
			this.lblDetails.TabIndex = 3;
			this.lblDetails.Text = "Details";
			this.lblDetails.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// grpIcon
			// 
			this.grpIcon.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpIcon.Controls.Add(this.picWarning);
			this.grpIcon.Location = new System.Drawing.Point(4, 32);
			this.grpIcon.Name = "grpIcon";
			this.grpIcon.Size = new System.Drawing.Size(52, 152);
			this.grpIcon.TabIndex = 4;
			this.grpIcon.TabStop = false;
			// 
			// picWarning
			// 
			this.picWarning.Image = ((System.Drawing.Image)(resources.GetObject("picWarning.Image")));
			this.picWarning.Location = new System.Drawing.Point(4, 12);
			this.picWarning.Name = "picWarning";
			this.picWarning.Size = new System.Drawing.Size(45, 45);
			this.picWarning.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picWarning.TabIndex = 0;
			this.picWarning.TabStop = false;
			// 
			// DlgCancelActiveOrderComment
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(352, 220);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.grpComment);
			this.Controls.Add(this.grpIcon);
			this.hlphelpChm.SetHelpKeyword(this, "Cancel_an_Active_Order.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.MinimumSize = new System.Drawing.Size(360, 247);
			this.Name = "DlgCancelActiveOrderComment";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Cancel Order(s)";
			this.Controls.SetChildIndex(this.grpIcon, 0);
			this.Controls.SetChildIndex(this.grpComment, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.grpComment.ResumeLayout(false);
			this.grpIcon.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Get/Set CannedCommentGuid
		/// </summary>
		public Guid CannedCommentGuid
		{
			get 
			{
				return _cannedCommentGuid;
			}
			set 
			{
				_cannedCommentGuid = value;
			}
		}

		/// <summary>
		/// Get/Set CannedCommentText
		/// </summary>
		public string CannedCommentText
		{
			get 
			{
				return _cannedCommentText;
			}
			set 
			{
				_cannedCommentText = value;
			}
		}
 
		private void SetComponentProperties()
		{
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			this._dtCannedComments = BOL.CannedComment.GetCannedComments(LogonUser.LogonUserDivisionCode, "OC");

			foreach(DataRow dr in _dtCannedComments.Rows)
			{
				this.cmbComment.Items.Add(dr[Common.VbecsTables.CannedComment.CannedCommentText]);
			}
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
			this.DialogResult = DialogResult.Cancel;
		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			if (this.txtComment.Text.Trim() != "")
			{
				this.CannedCommentText += " ";
				this.CannedCommentText += this.txtComment.Text.Trim();
			}
			this.Close();
			this.DialogResult = DialogResult.OK;
		}

		private void cmbComment_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (this.cmbComment.SelectedIndex != -1)
			{
				this.CannedCommentGuid = (Guid)this._dtCannedComments.Rows[this.cmbComment.SelectedIndex][Common.VbecsTables.CannedComment.CannedCommentGuid];
				this.CannedCommentText = this.cmbComment.Text;
				this.btnOK.EnabledButton = true;
			}
			else
			{
				this.btnOK.EnabledButton = false;
			}
		}
	}
}

